const config = require('./config');

const proxy = {
  target: "http://192.168.1.22:8080",
  changeOrigin: true,
  pathRewrite: {
    "^/api": "/bm/api"
  }
};

const resource_proxy = {
  target: "http://192.168.1.22:8080",
  changeOrigin: true,
  pathRewrite: {
    "^/resource": "/bm/resource"
  }
};

module.exports = {
  entry: "src/index.js",
  html: {
    title: 'base project',
    template: "src/index.ejs",
  },
  theme: {
    "layout-header-height": "48px",
    "layout-header-background": "#fff",
    "layout-footer-background": "#fff",
    "layout-sider-background": '#404040',
    'menu-dark-bg': '#404040',
    "layout-header-padding": "0",
  },
  browserslist: ['ie >= 9'],
  ignoreMomentLocale: true,
  hash: true,
  env: {
    development: {
      publicPath: config.dev.publicPath,
      extraBabelPlugins: [
        "dva-hmr",
        "lodash",
        ["import", { "libraryName": "antd", "style": true }]
      ],
      devtool: "cheap-module-eval-source-map",
      proxy: {
        "/api": proxy,
        "/resource": resource_proxy,
      }
    },
    production: {
      publicPath: config.prod.publicPath,
      extraBabelPlugins: [
        "lodash",
        ["import", { "libraryName": "antd", "style": true }]
      ],
      // devtool: "hidden-source-map"
    }
  }
};
