const makeSureEndsWithSlash = (path) => {
  if (!path || !path.endsWith('/')) {
    return `${path || ''}/`;
  } else {
    return path;
  }
};

const makeSureStartsWithSlash = (path) => {
  if (!path || !path.startsWith('/')) {
    return `/${path || ''}`;
  } else {
    return path;
  }
};

const tripEndSlash = (path) => {
  if (path && path.endsWith('/')) {
    return path.slice(0, path.length - 1);
  } else {
    return path;
  }
};

const contextPathDev = '';
const contextPathProd = 'bm/console';

const apiContextPathDev = '';
const apiContextPathProd = 'bm';

module.exports = {
  dev: {
    publicPath: makeSureEndsWithSlash(makeSureStartsWithSlash(contextPathDev)),
    basename: tripEndSlash(makeSureStartsWithSlash(contextPathDev)),
    contextPath: tripEndSlash(makeSureStartsWithSlash(contextPathDev)),
    apiContextPath: tripEndSlash(makeSureStartsWithSlash(apiContextPathDev)),
  },
  prod: {
    publicPath: makeSureEndsWithSlash(makeSureStartsWithSlash(contextPathProd)),
    basename: tripEndSlash(makeSureStartsWithSlash(contextPathProd)),
    contextPath: tripEndSlash(makeSureStartsWithSlash(contextPathProd)),
    apiContextPath: tripEndSlash(makeSureStartsWithSlash(apiContextPathProd)),
  },
};
