/* eslint-disable no-shadow */
import moment from 'moment';
import { genModules } from './src/mock/modules';
import { getTasks } from './src/mock/tasks';
import toFilters from './src/mock/filter';

const modules = genModules();
const tasks = getTasks();

const domains = [
  {
    id: 1,
    name: '虚拟基地01',
  },
  {
    id: 2,
    name: '虚拟基地02',
  },
  {
    id: 3,
    name: '虚拟基地03',
  },
  {
    id: 4,
    name: '虚拟基地04',
  },
  {
    id: 5,
    name: '虚拟基地05',
  },
];

const getDomain = (id) => {
  const domain = domains.filter(domain => domain.id === id);
  return domain ? domain[0] : null;
};

const dealWithData = (req) => {
  const { sort, order } = req.query;
  const filters = [];
  for (const queryKey in req.query) {
    if (queryKey.indexOf('f-') === 0) {
      filters.push(toFilters(queryKey, req.query[queryKey]));
    }
  }
  let data = tasks.filter((value) => {
    return filters.map(filter => filter(value)).reduce((ret, cur) => ret && cur, true);
  });
  if (sort) {
    data = data.sort((a, b) => {
      const va = a[sort];
      const vb = b[sort];
      if (order === 'desc') {
        if (moment.isMoment(va) || moment.isDate(va) || moment.isMoment(vb) || moment.isDate(vb)) {
          if (moment(va).isAfter(moment(vb))) {
            return 1;
          } else if (moment(va).isSame(moment(vb))) {
            return 0;
          } else {
            return -1;
          }
        } else if (va > vb) {
          return 1;
        } else if (va === vb) {
          return 0;
        } else {
          return -1;
        }
      } else if (moment.isMoment(va) || moment.isDate(va) || moment.isMoment(vb) || moment.isDate(vb)) {
        if (moment(va).isBefore(moment(vb))) {
          return 1;
        } else if (moment(va).isSame(moment(vb))) {
          return 0;
        } else {
          return -1;
        }
      } else if (va < vb) {
        return 1;
      } else if (va === vb) {
        return 0;
      } else {
        return -1;
      }
    });
  }
  return data;
};

let currentDomainId = null;

const wrapResponse = (response) => {
  return {
    errorCode: 0,
    data: response,
  };
};

module.exports = {

  '/api/user/logout': (req, res) => {
    res.status(204).end();
  },
  '/api/domain/all': wrapResponse(domains),
  '/api/domain/switch': (req, res) => {
    const { domainId } = req.query;
    const intDomainId = parseInt(domainId, 10);
    const domainIds = domains.map(domain => domain.id);
    if (domainIds.indexOf(intDomainId) !== -1) {
      if (currentDomainId) {
        res.send(wrapResponse(getDomain(currentDomainId)));
      } else {
        res.status(204).end();
      }
      currentDomainId = intDomainId;
    } else {
      res.status(500).send({
        errorCode: 0x00010010,
        message: '无效的项目ID。',
      });
    }
  },
  '/api/domain/current': (req, res) => {
    res.send(wrapResponse(getDomain(currentDomainId)));
  },
  '/api/module/all/info': (req, res) => {
    console.log('/api/module/all/info');
    const { all } = modules;
    const publics = modules.public;
    const findModule = id => all.filter(m => m.id === id).pop();
    const fetchParent = (module) => {
      if (module.parent) {
        const parent = findModule(module.parent);
        return parent ? [parent, ...fetchParent(parent)] : [];
      } else {
        return [];
      }
    };
    const parents = new Set();
    publics.forEach((m) => {
      const p0 = fetchParent(m);
      p0.forEach((p) => {
        parents.add(p);
      });
    });
    res.send(wrapResponse([
      ...publics,
      ...parents,
    ]));
  },
  '/api/bpm/task/all/count': (req, res) => {
    res.send(wrapResponse(dealWithData(req).length));
  },
  '/api/bpm/task/all/info': (req, res) => {
    const pst = Number.parseInt(req.query.pst, 10);
    const psz = Number.parseInt(req.query.psz, 10);
    res.send(wrapResponse(dealWithData(req).slice(pst, pst + psz)));
  },
};
