import { makePath } from '../../utils/helper';

const route = (routes) => {
  const Wrapper = ({ children }) => {
    return children || null;
  };
  Wrapper.route = {
    indexRoute: {
      onEnter(nextState, replace) {
        if (routes && routes.childRoutes && routes.childRoutes.length > 0) {
          const index = routes.childRoutes[0];
          replace(makePath(nextState.match.url, index.path));
        }
      },
    },
    ...routes,
  };
  return Wrapper;
};

export default route;
