import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Checkbox, Button } from 'antd';
import isString from 'lodash/isString';
import styles from './enum.less';

class EnumSearch extends Component {
  static getValue(filterEnum) {
    if (isString(filterEnum)) {
      return filterEnum;
    } else {
      return filterEnum ? filterEnum.value : null;
    }
  }
  static getText(filterEnum) {
    if (isString(filterEnum)) {
      return filterEnum;
    } else {
      return filterEnum ? filterEnum.text : null;
    }
  }

  constructor(props, context) {
    super(props, context);
    this.submit = this::this.submit;
    this.reset = this::this.reset;
    const checked = props.filterEnums.map(() => false);
    this.state = {
      checked,
    };
  }

  submit() {
    const { onSearchSubmit } = this.props;
    const values = this.props.filterEnums
      .filter((filterEnum, index) => this.state.checked[index])
      .map(filterEnum => EnumSearch.getValue(filterEnum));
    if (values && values.length === 1) {
      onSearchSubmit(`=${values[0]}`);
    } else if (values && values.length > 1) {
      onSearchSubmit(`^${values.join(',')}`);
    } else {
      onSearchSubmit(null);
    }
  }
  reset() {
    this.setState({
      checked: this.state.checked.map(() => false),
    });
  }

  render() {
    const filterEnums = this.props.filterEnums;
    return (
      <div className={styles.container}>
        {
          filterEnums.map((filterEnum, index) => {
            const onChange = (e) => {
              const checked = [...this.state.checked];
              checked[index] = e.target.checked;
              this.setState({ checked });
            };
            return (
              <span key={index}>
                <Checkbox checked={this.state.checked[index]} onChange={onChange}>
                  { EnumSearch.getText(filterEnum) }
                </Checkbox>
                <br />
              </span>
            );
          }, this)
        }
        <div className={styles.buttonBar}>
          <Button onClick={this.submit}>ok</Button>
          <Button onClick={this.reset} className={styles.reset}>reset</Button>
        </div>
      </div>
    );
  }
}

EnumSearch.propTypes = {
  filterEnums: PropTypes.arrayOf(PropTypes.shape({
    text: PropTypes.string,
    value: PropTypes.string,
  })).isRequired,
  onSearchSubmit: PropTypes.func,
};

const funcVoid = () => {};

EnumSearch.defaultProps = {
  onSearchSubmit: funcVoid,
};

export default EnumSearch;
