import Mock from 'mockjs';

const Random = Mock.Random;

const padDigits = (number, digits) => {
  return new Array(Math.max(digits - String(number).length + 1, 0)).join('0') + number;
};

let baseId = 10000;
let groupIdx = 1;
let moduleIdx = 1;
const groupPool = [];

const groupIdGenerator = () => {
  const id = baseId++;
  groupPool.push({
    id,
    children: [],
  });
  return id;
};

const groupNameGenerator = () => `模块组${padDigits(groupIdx++, 2)}`;

const moduleIdGenerator = () => baseId++;

const moduleNameGenerator = () => `模块${padDigits(moduleIdx++, 2)}`;

// eslint-disable-next-line func-names
const parentPicker = isRoot => function () {
  if (!isRoot) {
    const parent = Random.pick(groupPool);
    parent.children.push(this.id);
    return Number.parseInt(parent.id, 10);
  } else {
    return null;
  }
};

const moduleCreator = () => {
  const leafGroupPool = groupPool.filter(group => group.children.length === 0);
  const modules0 = Mock.mock({
    [`modules|${leafGroupPool.length}-${leafGroupPool.length}`]: [{
      id: moduleIdGenerator,
      name: moduleNameGenerator,
      'parent|+1': leafGroupPool.map(group => group.id),
    }],
  }).modules;
  const modules1 = Mock.mock({
    [`modules|0-${3 * groupPool.length}`]: [{
      id: moduleIdGenerator,
      name: moduleNameGenerator,
      'parent|1': groupPool.map(group => group.id),
    }],
  }).modules;
  return [
    ...modules0,
    ...modules1,
  ];
};

const defaultGroups = [{
  id: 1,
  name: '业务流程',
  parent: null,
  group: true,
}, {
  id: 2,
  name: '业务流程1',
  parent: 1,
  group: true,
}];

const defaultModules = [{
  id: 1000,
  name: '当前任务',
  parent: 1,
  route: 'task',
}, {
  id: 1001,
  name: '当前任务1',
  parent: 2,
  route: 'task',
}];

export function genModules() {
  const mock = Mock.mock({
    'groups|3-5': [{
      name: groupNameGenerator,
      parent: parentPicker(true),
      id: groupIdGenerator,
      group: true,
    }],
    'subGroups|0-15': [{
      name: groupNameGenerator,
      parent: parentPicker(false),
      id: groupIdGenerator,
      group: true,
    }],
    modules: moduleCreator,
  });
  const mNum = mock.modules.length;
  return {
    all: [
      ...defaultGroups,
      ...mock.groups,
      ...mock.subGroups,
      ...mock.modules,
      ...defaultModules,
    ],
    public: [...defaultModules, ...Random.pick(mock.modules, (mNum / 3) | 0, (2 * mNum / 3) | 0)],
  };
}
