import React from 'react';
import { Input, Select } from 'antd';
import styles from './authInput.less';

class AuthInputs extends React.Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      index: props.data.length > 0 ? 0 : -1,
    };
  }

  onChange = (value) => {
    this.setState({
      index: this.props.data.findIndex(item => item.key === value),
    });
  };
  render() {
    const { data } = this.props;
    const select = this.state.index >= 0 ? data[this.state.index].key : undefined;
    if (data.length > 0) {
      return (
        <Input.Group compact className={styles['bl-authInput']}>
          <Select value={select} onChange={this.onChange} style={{ width: '30%' }}>
            {
              data.map(item => (<Select.Option value={item.key} key={item.key}> { item.label } </Select.Option>))
            }
          </Select>
          {
            React.cloneElement(data[this.state.index >= 0 ? this.state.index : 0].node(),
              {
                style: { width: '70%' },
              })
          }
        </Input.Group>
      );
    }
  }
}

export default AuthInputs;
