# 作用域

用户永远处于某一作用域下。作用域从高到低，
分别是全市，区，项目，基地。每一个作用域都有自己的唯一编号。
任意一个作用域可以用作用域路径来唯一标识。
作用域路径即将此作用域从高到低的各个作用域的编号拼接成一个路径地址。
特别的，全市的作用域路径为`/`。

举个例子。假设黄浦区的作用域编号为HP，
黄浦区下某项目的作用域编号为HP01，
该项目下某基地的作用域编号为HP011，
那么黄浦区的作用域路径为`/HP`；
项目HP01的作用域路径为`/HP/HP01`；
基地HP011的作用域路径为`/HP/HP01/HP011`.

绝大多数接口都是受限于当前作用域的。
处于错误的作用域，调用相同名称的接口，
即使参数都一样，也往往产生错误的结果。
所以登录验证后第一件事就是切换到正确的作用域。

## 切换作用域

当前作用域是临时地保存在服务端的，每次重新登录后，之前设置的作用域都将失效，必须重新设置。

- **URL**:
/api/domain/user/path

- **Method**:
POST

- **Accept**:
application/json
  - *dmPath* - **string** 作用域路径

- **Content-Type**: 
application/json
  - `null`
  
# 获取当前作用域路径

- **URL**:
/api/domain/user/path

- **Method**:
GET

- **query parameter**
  - 无 - 只包含前置说明中提到的token， 之后不再重复说明。

- **Content-Type**: 
application/json
  - `null`
