import { makeAsync } from 'react-async-wrapper';
import md from '../markdown';

export default (match) => {
  const linkBase = `${match.url}/dynamic-interface`;
  const pathBase = `${match.path}/dynamic-interface`;
  return [
    ['addFamily', '新增两清'],
    ['addHouse', '新增房屋'],
    ['addPeople', '新增人口'],
    ['approveXieYi', '协议报审'],
    ['bindClerks', '绑定经办人'],
    ['generateXieYiPdf', '生成协议pdf'],
    ['getClerks', '获取经办人'],
    ['getXieYiPdf', '获取协议pdf'],
    ['importFangYuan', '导入房源'],
    ['isLiangQingLocked', '查询两清是否锁定'],
    ['isXieYiApproved', '查询协议是否审核'],
    ['isXieYiLocked', '查询协议是否锁定'],
    ['lockLiangQing', '锁定两清'],
    ['lockXieYi', '锁定协议'],
    ['removeFamily', '删除两清'],
    ['removeFangYuan', '删除房源'],
    ['removeHouse', '删除房屋'],
    ['removePeople', '删除人口'],
    ['requestCancelXieYi', '申请撤销协议'],
    ['requestUnLockLiangQing', '申请解锁两清'],
    ['updateFamily', '更新两清'],
    ['updateHouse', '更新房屋'],
    ['updatePeople', '更新人口'],
    ['updateXieYi', '更新协议'],
  ].map(([name, showName]) => ({
    name,
    showName,
    link: `${linkBase}/${name}`,
    path: `${pathBase}/${name}`,
    component: makeAsync({})(import(`./${name}.md`).then(md)),
  }));
};

