# 动态接口

动态接口可以可以看作函数，有参数，有返回值。
具体执行的内容在后台由技术人员进行配置，
理论上任何任务都可以通过这个api完成。
因为是可配置的，所以称之为**动态**的，
不过一般情况下，进入生产环境配置好的接口不会轻易改动，
除非有bug。

## 验证前置条件
调用动态接口可能需要满足某些状态条件，使用这个api来事先进行检测。
改api如果检测满足前置条件，则没有返回值，如果不满足条件`errorCode`则不为0，
`errorCode`含义依赖于具体配置，另外`message`字段也可能包含错误信息，
`data`字段可能包含特定的错误数据。

- **URL**
/api/interface/user/{name}/invoke/validateState
  - *name* - 动态接口的名称，可以认为是动态接口的唯一标识符。
  
- **Method**:
GET

- **query parameter**
  - 无
  
- **Content-Type**: 
application/json
  - `null`

## 调用动态接口
执行动态接口，调用此接口，服务端仍然会进行前置条件验证。

- **URL**:
/api/interface/user/{name}/invoke
  - *name* - 动态接口的名称，可以认为是动态接口的唯一标识符。

- **Method**:
POST

- **Accept**:
application/json
  - *params* - **object** 动态接口的参数，类似函数的参数。
    任意键值对，键为字符串，值为任意合法的**json**值类型。
    具体的形式依赖于当前动态接口的配置。
    
- **Content-Type**: 
application/json 
  - \- **any** 返回值没有固定类型，完全依赖于配置。
