/* eslint-disable no-undef */
import React from 'react';
import { Link, Route, Switch } from 'dva/router';
import 'github-markdown-css';
import styles from './index.less';
import mdIndex from './index.md';
import mdAuth from './auth.md';
import mdDomain from './domain.md';
import mdDyInt from './dynamic-interface/index.md';
import createPages from './dynamic-interface';
import md from './markdown';

class DocMainPage extends React.Component {
  render() {
    const { match } = this.props;
    const pages = createPages(match);
    return (
      <div className={styles.main}>
        <div className={styles.leftMenu}>
          <ul className={styles.catalogue}>
            <li>
              <Link to={`${match.url}/index`}>前置说明</Link>
            </li>
            <li>
              <Link to={`${match.url}/auth`}>登录与认证</Link>
            </li>
            <li>
              <Link to={`${match.url}/domain`}>作用域</Link>
            </li>
            <li>
              <Link to={`${match.url}/dynamic-interface`}>动态接口</Link>
              <ul>
                {
                  pages.map(page => (
                    <li key={page.name}><Link to={page.link}>{ page.showName }</Link></li>
                  ))
                }
              </ul>
            </li>
          </ul>
        </div>
        <div className={styles.contents}>
          <Switch>
            <Route path={`${match.path}/index`} component={md(mdIndex)} />
            <Route path={`${match.path}/auth`} component={md(mdAuth)} />
            <Route path={`${match.path}/domain`} component={md(mdDomain)} />
            <Route path={`${match.path}/dynamic-interface`} exact component={md(mdDyInt)} />
            {
              pages.map(page => (
                <Route key={page.name} path={page.path} component={page.component} />
              ))
            }
          </Switch>
        </div>
      </div>
    );
  }
}

export default DocMainPage;
