import baseConfig from '../../config';

/* eslint-disable no-undef */
/**
 * Created by yaohx_169 on 2017/6/6.
 */

export const cookie = {
  token: 'token',
  userId: 'userId',
  userName: 'userName',
  domainPath: 'domainPath',
  domainName: 'domainName',
};

export const errors = {
  exception: 0x00010000,
  no_such_user: 0x00010001,
  wrong_password: 0x00010002,
  invalid_token: 0x00010003,
  invalid_query_param: 0x00010004,
  domain_not_set: 0x00010005,
  wrong_sms_code: 0x00010006,
  sms_code_time_out: 0x00010007,
  invalid_mobile: 0x00010008,
  no_operation_right: 0x00010100,
  no_module_right: 0x00010101,
  no_interface_right: 0x00010102,
  no_batch_right: 0x00010103,
  no_resource_right: 0x00010104,
  no_domain_right: 0x00010105,
  no_datasource_right: 0x00010106,
  general_error: 0x00011111,
  // client error:
  token_missing: 0x00000001,
  unsupported_auth_type: 0x00000003,
  auth_failed: 0x00000004,
};

export const api = {
  userLogin: '/user/login',
  userLogout: '/user/logout',
  userInfo: '/userInfo',
  users: '/users',
  user: '/user/:id',
  dashboard: '/dashboard',
};

const defaultDateFormat = 'YYYY-MM-DD';
const defaultTimeFormat = 'HH:mm:ss';
const defaultDateTimeFormat = `${defaultDateFormat} ${defaultTimeFormat}`;

const dev = process.env.NODE_ENV === 'development';

const contextPath = dev ? baseConfig.dev.contextPath : baseConfig.prod.contextPath;
const apiContextPath = dev ? baseConfig.dev.apiContextPath : baseConfig.prod.apiContextPath;
const basename = dev ? baseConfig.dev.basename : baseConfig.prod.basename;

const config = {
  name: 'Jbpm Demo',
  footerText: '上海铂蓝信息科技有限公司',
  logo: `${contextPath}/logo.png`,
  basename,
  contextPath,
  apiContextPath,
  productId: 'big-machine-web-front',
  fastNavigationPage: '',
  defaultDateFormat,
  defaultTimeFormat,
  defaultDateTimeFormat,
  pubKey: '-----BEGIN PUBLIC KEY-----MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC+/Rs6dYmdtETjHCZq4LF3QjLM/DocRAXrqtMULZf+579dAn+CiM8noLplZT/DRwvfK822eq8sypH+a4NqP7942pPVjOudVvKfiJvmm2TOQHvQ7vi3iyZVdlsxX72JNFo1Ocqwj48aIC/OJ4bMf/VyCKrmKrU2iXND+I4BN8cfhwIDAQAB-----END PUBLIC KEY-----',
};

export default config;
