/* eslint-disable no-param-reassign */
import isNil from 'lodash/isNil';
import defaults from 'lodash/defaults';
import { fetch } from './polyfill';
import { checkStatus, normParams, parseObject } from './http-helper';
import middleware from './middleware';

const defaultOptions = {
  headers: {
    Accept: 'application/json',
  },
};

const sortBodyForToken = (keys) => {
  const idxToken = keys.indexOf('token');
  if (idxToken !== -1) {
    if (idxToken === 0) {
      return keys;
    } else if (idxToken === keys.length - 1) {
      return ['token', ...keys.slice(0, keys.length - 1)];
    } else {
      return ['token', ...keys.slice(0, idxToken), ...keys.slice(idxToken + 1)];
    }
  } else {
    return keys;
  }
};

const orderedStringify = (obj) => {
  const allKeys = [];
  JSON.stringify(obj, (k, v) => { allKeys.push(k); return v; });
  return JSON.stringify(obj, sortBodyForToken(allKeys));
};

export default async function post(url, data, params = {}, options = {}, auth = true) {
  if (!data) {
    data = {};
  }
  params = normParams(params);
  const res = await middleware.post.onRequest(url, data, params, options, auth);
  let queryParams = res ? res.params : params;
  queryParams = queryParams.map(([k, v]) => (isNil(v) ? k : `${k}=${encodeURIComponent(v)}`));
  queryParams = queryParams.join('&');
  let realUrl = res ? res.url : url;
  if (queryParams) {
    realUrl = `${url}?${queryParams}`;
  }
  const realOptions = defaults(res ? res.options : options, defaultOptions);
  if (!realOptions.headers) {
    realOptions.headers = {
      Accept: 'application/json',
    };
  }
  realOptions.headers['Content-Type'] = 'application/json';
  realOptions.method = 'POST';
  const body = res ? res.data : data;
  realOptions.body = orderedStringify(body);
  return fetch(realUrl, realOptions)
    .then(checkStatus)
    .then(resp => parseObject(resp, middleware.post.onResponse));
}
