import isNil from 'lodash/isNil';
import defaults from 'lodash/defaults';
import { fetch } from './polyfill';
import { checkStatus, normParams, parseObject } from './http-helper';
import middleware from './middleware';

const defaultOptions = {
  headers: { Accept: 'application/json' },
};

/**
 * Requests a URL, returning a promise.
 *
 * @param  {string} url       The URL we want to request
 * @param auth
 * @param params
 * @param  {object} [options] The options we want to pass to "fetch"
 * @return {object}           An object containing either "data" or "err"
 */
export default async function request(url, params = {}, options = {}, auth = true) {
  const normedParams = normParams(params);
  const res = await middleware.get.onRequest(url, normedParams, options, auth);
  const newUrl = res ? res.url : url;
  const newParams = res ? res.params : normedParams;
  const newOptions = res ? res.options : options;
  let queryParams = newParams.map(([k, v]) => (isNil(v) ? k : `${k}=${encodeURIComponent(v)}`));
  queryParams = queryParams.join('&');
  let realUrl = newUrl;
  if (queryParams) {
    realUrl = `${url}?${queryParams}`;
  }
  return fetch(realUrl, defaults(newOptions, defaultOptions))
    .then(checkStatus)
    .then(resp => parseObject(resp, middleware.get.onResponse));
}

