/* eslint-disable no-param-reassign */
const path = require('path');
const omit = require('lodash/omit');
const isFunction = require('lodash/isFunction');
const isUndefined = require('lodash/isUndefined');
const isObject = require('lodash/isObject');
const isEmpty = require('lodash/isEmpty');
const isArray = require('lodash/isArray');
const iteratee = require('lodash/iteratee');
const flatten = require('lodash/flatten');
const includes = require('lodash/includes');
const transform = require('lodash/transform');
const inspect = require('util').inspect;
const writeFileSync = require('fs').writeFileSync;

function pickDeep(collection, ...args) {
  let predicate = args[0];
  if (isFunction(predicate)) {
    predicate = iteratee(predicate);
  } else {
    const keys = flatten(args);
    predicate = (val, key) => {
      return includes(keys, key);
    };
  }

  return transform(collection, (memo, val, key) => {
    let include = predicate(val, key);
    if (include && (isObject(val) || isArray(val))) {
      val = pickDeep(val, predicate);
      include = !isEmpty(val);
    }
    if (include) {
      if (isArray(collection)) {
        memo.push(val);
      } else {
        memo[key] = val;
      }
    }
  });
}

module.exports = function webpack(config) {
  config.module.rules.push({
    test: /\.ejs$/,
    loader: require.resolve('ejs-loader'),
  });
  config.module.rules = config.module.rules.map((rule) => {
    if (!rule.test && rule.exclude) {
      rule.exclude = [...rule.exclude, /\.md$/];
    }
    return rule;
  });
  config.module.rules.push({
    test: /\.md$/,
    use: [
      // require.resolve('html-loader'),
      // require.resolve('highlight-loader'),
      require.resolve('raw-loader'),
    ],
  });
  // console.log(config.module.rules);
  let cleanedConfig = omit(config, 'plugins');
  cleanedConfig.resolve = omit(cleanedConfig.resolve, 'plugins');
  cleanedConfig = pickDeep(cleanedConfig, v => !isFunction(v) && !isUndefined(v));
  writeFileSync(path.resolve(__dirname, 'webpack/webpack.config.js'), `module.exports = ${inspect(cleanedConfig, false, null)};`);
  return config;
};
