const proxy = {
  "target": "http://192.168.1.22:8080",
  "changeOrigin": true,
  "pathRewrite": {
    "^/api": "/bm/api"
  }
};

const resource_proxy = {
  "target": "http://192.168.1.22:8080",
  "changeOrigin": true,
  "pathRewrite": {
    "^/resource": "/bm/resource"
  }
};

module.exports = {
  "entry": "src/index.js",
  "theme": {
    "layout-header-height": "48px",
    "layout-header-background": "#fff",
    "layout-footer-background": "#fff",
    "layout-sider-background": '#404040',
    'menu-dark-bg': '#404040',
    "layout-header-padding": "0",
  },
  "env": {
    "development": {
      "extraBabelPlugins": [
        "dva-hmr",
        "transform-runtime",
        ["import", { "libraryName": "antd", "style": true }]
      ],
      "proxy": {
        "/api": proxy,
        "/resource": resource_proxy,
      }
    },
    "production": {
      publicPath: "/bm/",
      define: {
        contextPath: "/bm",
        apiContextPath: "/bm"
      },
      "extraBabelPlugins": [
        "transform-runtime",
        ["import", { "libraryName": "antd", "style": true }]
      ]
    }
  }
};
