import React from 'react';
import PropTypes from 'prop-types';
import { Menu, Icon } from 'antd';
import styles from './SiderMenu.less';

const SubMenu = Menu.SubMenu;
const MenuItem = Menu.Item;

class SiderMenu extends React.Component {

  constructor(props, context) {
    super(props, context);
    this.createMenus = this::this.createMenus;
  }
  createMenus() {
    const menus = this.props.menus;
    const mode = this.props.mode;
    const toTitle = (menu, root = true) => {
      const text = (mode !== 'inline' && root) ? '' : menu.text;
      if (menu.icon) {
        return (
          <span>
            <Icon type={menu.icon} />
            { text }
          </span>
        );
      } else {
        return text;
      }
    };
    const toMenuGroup = (menu, toMenuItemFunc, root = false) => {
      if (!menu.children || menu.children.length === 0) {
        return toMenuItemFunc(menu, toMenuGroup, root);
      }
      return (
        <SubMenu title={toTitle(menu, root)} key={menu.name}>
          { menu.children.map(child => toMenuItemFunc(child, toMenuGroup)) }
        </SubMenu>
      );
    };
    const toMenuItem = (menu, toMenuGroupFunc, root = false) => {
      if (menu.children && menu.children.length !== 0) {
        return toMenuGroupFunc(menu, toMenuItem, root);
      }
      return (
        <MenuItem key={menu.name}>
          { toTitle(menu, root) }
        </MenuItem>
      );
    };
    return menus.map(menu => toMenuGroup(menu, toMenuItem, true));
  }
  render() {
    const menuProps = {
      className: styles.menu,
      theme: this.props.theme,
      mode: this.props.mode,
      onClick: this.props.onClick,
    };
    return (
      <Menu {...menuProps}>
        { this.createMenus() }
      </Menu>
    );
  }

}

SiderMenu.propTypes = {
  theme: PropTypes.string,
  mode: PropTypes.string,
  menus: PropTypes.arrayOf(PropTypes.shape({
    name: PropTypes.string,
    icon: PropTypes.string,
    text: PropTypes.string,
    children: PropTypes.array,
  })),
};

SiderMenu.defaultProps = {
  theme: 'dark',
  mode: 'inline',
  menus: [],
};

export default SiderMenu;
