import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { DatePicker, Button } from 'antd';
import moment from 'moment';
import config from '../../../utils/config';
import styles from './date.less';

const RangePicker = DatePicker.RangePicker;

class DateSearch extends Component {

  constructor(props, context) {
    super(props, context);
    this.onClick = this::this.onClick;
    this.onChange = this::this.onChange;
    this.onOk = this::this.onOk;
    this.bindContainer = this::this.bindContainer;
    this.state = {
      value: [moment(), moment()],
    };
  }
  onClick() {
    const [start, end] = this.state.value;
    let sValue = '';
    let eValue = '';
    if (start && start.isValid()) {
      sValue = start.valueOf().toString();
    }
    if (end && end.isValid) {
      eValue = end.valueOf().toString();
    }
    const filter = (sValue || eValue) ? `~[${sValue},${eValue})` : null;
    this.props.onSearchSubmit(filter);
  }
  onChange(value) {
    this.setState({
      value,
    });
  }
  onOk(value) {
    this.setState({
      value,
    });
  }
  bindContainer(node) {
    this.container = node;
  }

  render() {
    return (
      <div ref={this.bindContainer} className={styles.container}>
        <RangePicker
          showTime
          value={this.state.value}
          format={config.defaultDateTimeFormat}
          placeholder={['开始时间', '结束时间']}
          onChange={this.onChange}
          onOk={this.onOk}
          getCalendarContainer={() => this.container}
        />
        <Button className={styles.popupOk} onClick={this.onClick}>ok</Button>
      </div>
    );
  }
}

DateSearch.propTypes = {
  onSearchSubmit: PropTypes.func,
};

const funcVoid = () => {};

DateSearch.defaultProps = {
  onSearchSubmit: funcVoid,
};

export default DateSearch;
