import React from 'react';
import PropTypes from 'prop-types';
import { Icon } from 'antd';
import TextSearch from './text';
import DateSearch from './date';
import EnumSearch from './enum';

const Search = (props) => {
  const { type, onSearchSubmit, filterEnums, children, ...rest } = props;
  if (type === 'text') {
    return (
      <TextSearch onSearchSubmit={onSearchSubmit} {...rest}>
        { children }
      </TextSearch>
    );
  } else if (type === 'date') {
    return <DateSearch onSearchSubmit={onSearchSubmit} {...rest} />;
  } else if (type === 'enum') {
    return <EnumSearch filterEnums={filterEnums} onSearchSubmit={onSearchSubmit} {...rest} />;
  } else {
    return null;
  }
};

Search.getIcon = (type, filtered) => {
  const style = {
    color: filtered ? '#108ee9' : '#aaa',
  };
  if (type === 'text') {
    return (
      <Icon type="search" style={style} />
    );
  } else if (type === 'date') {
    return (
      <Icon type="calendar" style={style} />
    );
  } else if (type === 'enum') {
    return (
      <Icon type="filter" style={style} />
    );
  } else {
    return null;
  }
};

Search.propTypes = {
  onSearchSubmit: PropTypes.func,
};

export default Search;
