import dva from 'dva';
import createLoading from 'dva-loading';
import moment from 'moment';
import { history } from './services/route';
import { initApp } from './data/app';
import appModel from './models/app';
import routerConfig from './router';
import { processError } from './utils/error';
import './index.css';

moment.locale('zh-cn');

// 1. Initialize
const app = dva({
  history,
  onError(error) {
// eslint-disable-next-line no-console
    processError(error);
  },
});

app.model(appModel);

// 2. Plugins
app.use(createLoading({
  effects: true,
}));

// 3. Model
// app.model(require('./models/example'));

// 4. Router
app.router(routerConfig);

// 5. Start
initApp(app).then(theApp => theApp.start('#root'));

export default app;

export const getStore = () => {
  // eslint-disable-next-line no-underscore-dangle
  return app._store;
};
