import { routerRedux } from 'dva/router';
import { fetchDomains, switchDomain, currentDomain } from '../services/domain';
import { fullPath } from '../utils/helper';
import { getDomain, histories, setDomain } from '../utils/auth';
import config from '../utils/config';

export default {

  namespace: 'domain',

  state: {
    init: undefined,
    list: [],
  },

  subscriptions: {
    setup({ dispatch }) {  // eslint-disable-line
    },
  },

  effects: {
    *fetch(ignored, { put, call }) {
      const domain = yield call(getDomain);
      const init = domain ? domain.path : undefined;
      const list = yield call(fetchDomains, '/', true);
      yield put({ type: 'queryInit', payload: init });
      yield put({ type: 'queryList', payload: list });
    },
    *switch({ payload: domainPath }, { put, call }) {
      yield call(switchDomain, domainPath);
      const { path, name } = yield call(currentDomain);
      yield call(setDomain, name, path);
      yield put({ type: 'queryInit', payload: path });
      const latest = yield call(histories.getLatest, 'module');
      if (latest && config.fastNavigationPage) {
        yield put(routerRedux.push(fullPath('/fastNav')));
      } else {
        yield put(routerRedux.push(fullPath('/main')));
      }
    },
  },

  reducers: {
    queryInit(state, { payload: init }) {
      return {
        ...state,
        init,
      };
    },
    queryList(state, { payload: list }) {
      return {
        ...state,
        list,
      };
    },
  },

};
