import moment from 'moment';
import config from '../../../../utils/config';
import { countTasks, fetchTasks } from '../../../../services/bpm';

export default {
  namespace: 'task',
  state: {
    num: 0,
    list: [],
  },
  reducers: {
    queryCountSuccess(state, { payload: num }) {
      return {
        ...state,
        num,
      };
    },
    queryTasksSuccess(state, { payload: list }) {
      return {
        ...state,
        list,
      };
    },
  },
  effects: {
    *fetchTasks({ payload: { pst, psz, filters } }, { put, call }) {
      const num = Number.parseInt(yield call(countTasks, filters), 10);
      yield put({ type: 'queryCountSuccess', payload: num });
      const tasks = yield call(fetchTasks, { pst, psz, filters });
      yield put({
        type: 'queryTasksSuccess',
        payload: tasks.map((task) => {
          return {
            key: `${task.pId}-${task.nId}`,
            pName: task.pName,
            nName: task.nName,
            state: task.state,
            date: moment(task.date, config.defaultDateTimeFormat),
            deadline: moment(task.deadline, config.defaultDateTimeFormat),
          };
        }),
      });
    },
  },
  subscriptions: {},
};
