import { connect } from 'dva';
import { withRouter } from 'dva/router';
import List from './list';
import Detail from './detail';
import route from '../../../../components/hoc/routes';

export default connect(({ task }) => ({ task }))(route({
  childRoutes: [
    {
      path: 'list',
      name: '列表',
      component: withRouter(List, { withRef: true }),
    },
    {
      path: 'detail',
      name: '详细',
      component: withRouter(Detail, { withRef: true }),
    },
  ],
}));
