import React from 'react';
import PropTypes from 'prop-types';
import moment from 'moment';
import { Button } from 'antd';
import { connect } from 'dva';
import TableEx from '../../../../components/table/index';
import config from '../../../../utils/config';
import { thisPush } from '../../../../services/route';
import styles from './list.less';

const columns = [{
  title: '流程',
  dataIndex: 'pName',
  key: 'pName',
  filterType: 'text',
}, {
  title: '任务',
  dataIndex: 'nName',
  key: 'nName',
  filterType: 'text',
}, {
  title: '状态',
  dataIndex: 'state',
  key: 'state',
  filterType: 'enum',
  filterEnums: [{
    text: '状态1',
    value: '状态1',
  }, {
    text: '状态2',
    value: '状态2',
  }, {
    text: '状态3',
    value: '状态3',
  }, {
    text: '状态4',
    value: '状态4',
  }, {
    text: '状态5',
    value: '状态5',
  }],
}, {
  title: '日期',
  dataIndex: 'date',
  key: 'date',
  filterType: 'date',
  render(date) {
    return date.format(config.defaultDateTimeFormat);
  },
}, {
  title: '期限',
  dataIndex: 'deadline',
  key: 'deadline',
  render(deadline) {
    const now = moment();
    const late = deadline.diff(now, 'days', true);
    if (late < 0) {
      const style = {
        color: '#f04134',
      };
      return <span style={style}>{ `超时 ${deadline.from(now, true)}` }</span>;
    } else if (late < 1) {
      const style = {
        color: '#ffbf00',
      };
      return <span style={style}>{ `仅剩 ${deadline.to(now, true)}` }</span>;
    } else {
      const style = {
        color: '#00a854',
      };
      return <span style={style}>{ `还剩 ${deadline.to(now, true)}` }</span>;
    }
  },
}];


class List extends React.Component {

  constructor(props, context) {
    super(props, context);
    this.loadData = this::this.loadData;
    this.getCurrent = this::this.getCurrent;
    this.state = {
      filters: [],
      current: 1,
      pageSize: 10,
    };
  }
  componentDidMount() {
    this.loadData();
  }
  getCurrent() {
    const { num } = this.props.task;
    const pageNum = ((num / this.state.pageSize) | 0) + 1;
    return this.state.current > pageNum ? pageNum : this.state.current;
  }
  loadData() {
    const filters0 = this.state.filters
      .filter(({ filter }) => !!filter)
      .map(({ key, filter }) => ([
        `f-${key}`,
        filter,
      ]));
    const psz = this.state.pageSize; // eslint-disable-line no-shadow
    const pst = (this.state.current - 1) * psz;
    this.props.dispatch({ type: 'task/fetchTasks', payload: { pst, psz, filters: filters0 } });
  }
  render() {
    const { list, num } = this.props.task;
    const tableProps = {
      dataSource: list,
      columns,
      filters: this.state.filters.map(filter => filter.filter),
      loading: this.props.loading.effects['task/fetchTasks'],
      pagination: {
        current: this.state.current,
        total: num,
        pageSize: this.state.pageSize,
      },
      onChange: (pagination) => {
        this.setState({
          current: pagination.current,
          pageSize: pagination.pageSize,
        }, () => {
          this.loadData();
        });
      },
      onFilter: (filters) => {
        this.setState({
          filters,
          current: 1,
        }, () => {
          this.loadData();
        });
      },
    };
    return (
      <div className={styles.wrapper}>
        <div className={styles.container}>
          <Button onClick={() => { thisPush(this, { pathname: '../detail', state: { a: 1, b: 2, c: 3 } }); }}>detail</Button>
          <TableEx {...tableProps} />
        </div>
      </div>
    );
  }

}

List.propTypes = {
  task: PropTypes.object.isRequired,
};

export default connect(({ task, loading }) => ({ task, loading }))(List);
