import request from '../utils/request';
import post from '../utils/post';
import doDelete from '../utils/delete';
import config from '../utils/config';

export const userApi = {
  async getAllInterfaceInfoes() {
    return request(`${config.apiContextPath}/api/interface/user/info`);
  },
  async getInterfaceInfo(name) {
    return request(`${config.apiContextPath}/api/interface/user/${encodeURIComponent(name)}/info`);
  },
  async validateState(name, dmPath) {
    return request(`${config.apiContextPath}/api/interface/user/${encodeURIComponent(name)}/invoke/validateState`, { dmPath });
  },
  async invokeInterface(name, params, dmPath) {
    return post(`${config.apiContextPath}/api/interface/user/${encodeURIComponent(name)}/invoke`, { params, dmPath });
  },
};

export const adminApi = {
  async getAllInterfaceInfoes(dmPath) {
    return request(`${config.apiContextPath}/api/interface/admin/info`, { dmPath });
  },
  async getInterfaceInfo(name, dmPath) {
    return request(`${config.apiContextPath}/api/interface/admin/${encodeURIComponent(name)}/info`, { dmPath });
  },
  async getInterfaceConfigure(name, dmPath) {
    return request(`${config.apiContextPath}/api/interface/admin/${encodeURIComponent(name)}/configure`, { dmPath });
  },
  async getInterfacePlainConfigure(name, dmPath) {
    return post(`${config.apiContextPath}/api/interface/admin/${encodeURIComponent(name)}/plainConfigure`, { dmPath });
  },
  async setInterfaceConfigure(name, configure, dmPath) {
    return post(`${config.apiContextPath}/api/interface/admin/${encodeURIComponent(name)}/configure`, { configure, dmPath });
  },
  async removeInterfaceConfigure(name, dmPath) {
    return doDelete(`${config.apiContextPath}/api/interface/admin/${encodeURIComponent(name)}/configure`, { dmPath });
  },
};
