import { getToken } from '../../utils/auth';

export const addToken = async (request, token) => {
  if (token) {
    return {
      tkId: token,
      request,
    };
  } else {
    let tkId;
    const localToken = await getToken();
    if (localToken) {
      // eslint-disable-next-line no-param-reassign
      tkId = localToken;
    }
    if (tkId) {
      return {
        tkId,
        request,
      };
    } else {
      return {
        request,
      };
    }
  }
};
