import { castArray } from 'lodash';
import post from '../utils/post';
import config from '../utils/config';
import request from '../utils/request';

export class Operations {
  constructor() {
    this.operations = [];
  }
  addCmd = (cmd, ...args) => {
    this.operations.push({ cmd, args });
    return this;
  };
  setName = (name) => {
    return this.addCmd('setName', name);
  };
  setRight = (right) => {
    return this.addCmd('setRight', right);
  };
  addTags = (...tags) => {
    return this.addCmd('addTags', ...tags);
  };
  removeTags = (...tags) => {
    return this.addCmd('removeTags', ...tags);
  };
  clearTags = () => {
    return this.addCmd('clearTags');
  };
  setTags = (...tags) => {
    return this.addCmd('setTags', ...tags);
  };
  addOwners = (...owners) => {
    return this.addCmd('addOwners', ...owners);
  };
  removeOwners = (...owners) => {
    return this.addCmd('removeOwners', ...owners);
  };
  clearOwners = () => {
    return this.addCmd('clearOwners');
  };
  setOwners = (...owners) => {
    return this.addCmd('setOwners', ...owners);
  };
  addOwnerGroups = (...groups) => {
    return this.addCmd('addOwnerGroups', ...groups);
  };
  removeOwnerGroups = (...groups) => {
    return this.addCmd('removeOwnerGroups', ...groups);
  };
  clearOwnerGroups = () => {
    return this.addCmd('clearOwnerGroups');
  };
  setOwnerGroups = (...groups) => {
    return this.addCmd('setOwnerGroups', ...groups);
  };
  use = (usage) => {
    return this.addCmd('use', usage);
  };
  unuse = (usage) => {
    return this.addCmd('unuse', usage);
  };
}

export const createOperations = () => {
  return new Operations();
};

export async function editResource(uri, operations) {
  return post(`${config.apiContextPath}/api/resource/user/${encodeURIComponent(uri)}/meta`, { operations: operations.operations });
}

export async function getResourceInfo(uri) {
  return request(`${config.apiContextPath}/api/resource/user/${encodeURIComponent(uri)}/meta`);
}

export async function queryResourceByUsage(usage, pst = -1, psz = -1) {
  return request(`${config.apiContextPath}/api/resource/user/query`, { usage, pst, psz });
}

export async function queryResourceByUsageStartWith(usage, pst = -1, psz = -1) {
  return request(`${config.apiContextPath}/api/resource/user/query`, { usage, startWith: true, pst, psz });
}

export async function queryResourceByAllTags(tags, pst = -1, psz = -1) {
  return request(`${config.apiContextPath}/api/resource/user/query`, { tags: castArray(tags), pst, psz });
}

export async function queryResourceByAnyTags(tags, pst = -1, psz = -1) {
  return request(`${config.apiContextPath}/api/resource/user/query`, { tags: castArray(tags), andOr: 'or', pst, psz });
}

export async function queryResourceByUsageAndAllTags(usage, tags, pst = -1, psz = -1) {
  return request(`${config.apiContextPath}/api/resource/user/query`, { usage, tags: castArray(tags), pst, psz });
}

export async function queryResourceByUsageAndAnyTags(usage, tags, pst = -1, psz = -1) {
  return request(`${config.apiContextPath}/api/resource/user/query`, { usage, tags: castArray(tags), andOr: 'or', pst, psz });
}

export async function queryResourceByUsageStartWithAndAllTags(usage, tags, pst = -1, psz = -1) {
  return request(`${config.apiContextPath}/api/resource/user/query`, { usage, startWith: true, tags: castArray(tags), pst, psz });
}

export async function queryResourceByUsageStartWithAndAnyTags(usage, tags, pst = -1, psz = -1) {
  return request(`${config.apiContextPath}/api/resource/user/query`, { usage, startWith: true, tags: castArray(tags), andOr: 'or', pst, psz });
}
