/* eslint-disable no-param-reassign */
/**
 * Created by yaohx_169 on 2017/6/8.
 */
import { cookie } from './config';
import { getCookie, setCookie, delCookie } from './helper';
import db from './db';

export async function getToken() {
  return getCookie(cookie.token);
}

export async function setToken(token) {
  setCookie(cookie.token, token);
}

export async function delToken() {
  delCookie(cookie.token);
}

export async function getUser() {
  return {
    id: getCookie(cookie.userId),
    name: getCookie(cookie.userName),
  };
}

export async function setUser(id, name) {
  setCookie(cookie.userId, id);
  setCookie(cookie.userName, name);
}

export async function delUser() {
  delCookie(cookie.userId);
  delCookie(cookie.userName);
}

export async function getDomain() {
  return {
    name: getCookie(cookie.domainName),
    path: getCookie(cookie.domainPath),
  };
}

export async function setDomain(name, path) {
  setCookie(cookie.domainName, name);
  setCookie(cookie.domainPath, path);
}

export async function delDomain() {
  delCookie(cookie.domainName);
  delCookie(cookie.domainPath);
}

export async function isAuthed() {
  return getToken().then(result => !!result);
}

export async function hasDomain() {
  return getDomain().then(result => !!result);
}

const normHistory = (history, size) => {
  if (!history) {
    history = {};
  }
  if (!history.size) {
    if (size) {
      history.size = size;
    } else {
      history.size = 10;
    }
  } else if (size && history.size !== size) {
    history.size = size;
  }
  if (history.size < 1) {
    history.size = 1;
  }
  if (!history.data) {
    history.data = [];
    history.start = 0;
    history.top = 0;
    history.empty = true;
  }
  return history;
};

const next = (i, size) => {
  if (i < 0 || i >= size) {
    throw new Error(`out of range: ${i} in ${size}`);
  }
  if (i + 1 >= size) {
    return 0;
  } else {
    return i + 1;
  }
};

const prev = (i, size) => {
  if (i < 0 || i >= size) {
    throw new Error(`out of range: ${i} in ${size}`);
  }
  if (i - i < 0) {
    return size - 1;
  } else {
    return i - 1;
  }
};

export const histories = {
  async getLatest(name) {
    let history = await db.get(`history.${name}`).value();
    history = normHistory(history);
    if (history.empty) {
      return null;
    }
    return history.data[prev(history.top, history.size)];
  },
  async createHistory(name, size) {
    let history = db.get(`history.${name}`).value();
    history = normHistory(history, size);
    return db.set(`history.${name}`, history).write();
  },
  async destroyHistory(name) {
    return db.unset(`history.${name}`).write();
  },
  async getHistory(name, size) {
    let history = db.get(`history.${name}`).value();
    history = normHistory(history, size);
    if (history.empty) {
      return [];
    } else if (history.top > history.start) {
      return history.data.slice(history.start, history.top);
    } else {
      return [...history.data.slice(history.start, history.size), ...history.data.slice(0, history.top)];
    }
  },
  async pushHistory(name, value, size) {
    let history = await db.get(`history.${name}`).value();
    history = normHistory(history, size);
    history.data[history.top] = value;
    const nextPos = next(history.top, history.size);
    if (!history.empty && history.start === history.top) {
      history.top = history.start = nextPos;
    } else {
      history.top = nextPos;
    }
    if (history.empty) {
      history.empty = false;
    }
    return db.set(`history.${name}`, history).write();
  },
  async popHistory(name) {
    let history = await db.get(`history.${name}`).value();
    history = normHistory(history);
    if (history.empty) {
      return;
    }
    history.top = prev(history.top, history.size);
    if (history.top === history.start) {
      history.empty = true;
    }
    return db.set(`history.${name}`, history).write();
  },
  async init() {
    return db.read();
  },
};
