/* eslint-disable no-param-reassign */
import { isNil, defaults } from 'lodash';
import { fetch } from './polyfill';
import { checkStatus, normParams, parseObject } from './http-helper';
import middleware from './middleware';

const defaultOptions = {
  headers: {
    Accept: 'application/json',
  },
};

export default async function post(url, data, params = {}, options = {}, auth = true) {
  if (!data) {
    data = {};
  }
  params = normParams(params);
  const res = await middleware.post.onRequest(url, data, params, options, auth);
  let queryParams = res ? res.params : params;
  queryParams = queryParams.map(([k, v]) => (isNil(v) ? k : `${k}=${encodeURIComponent(v)}`));
  queryParams = queryParams.join('&');
  let realUrl = res ? res.url : url;
  if (queryParams) {
    realUrl = `${url}?${queryParams}`;
  }
  const realOptions = defaults(res ? res.options : options, defaultOptions);
  if (!realOptions.headers) {
    realOptions.headers = {
      Accept: 'application/json',
    };
  }
  realOptions.headers['Content-Type'] = 'application/json';
  realOptions.method = 'POST';
  realOptions.body = JSON.stringify(res ? res.data : data);
  return fetch(realUrl, realOptions)
    .then(checkStatus)
    .then(resp => parseObject(resp, middleware.post.onResponse));
}
