const proxy = {
  "target": "http://192.168.1.200:8090",
  "changeOrigin": true,
  "pathRewrite": {
    "^/api": "/big-machine/restful-services"
  }
};

const resource_proxy = {
  "target": "http://192.168.1.200:8090",
  "changeOrigin": true,
  "pathRewrite": {
    "^/": "/big-machine/"
  }
};

module.exports = {
  "entry": "src/index.js",
  "theme": {
    "layout-header-height": "48px",
    "layout-header-background": "#fff",
    "layout-footer-background": "#fff",
    "layout-sider-background": '#404040',
    'menu-dark-bg': '#404040',
    "layout-header-padding": "0",
  },
  "env": {
    "development": {
      "extraBabelPlugins": [
        "dva-hmr",
        "transform-runtime",
        ["import", { "libraryName": "antd", "style": true }]
      ],
      "proxy": {
        "/api/auth": proxy,
        "/api/user": proxy,
        "/api/domain": proxy,
        "/api/datasource": proxy,
        "/api/module": proxy,
        "/api/configure": proxy,
        "/api/interface": proxy,
        "/api/template": proxy,
        "/resource": resource_proxy,
      }
    },
    "production": {
      publicPath: "/bm/",
      define: {
        contextPath: "/bm",
        apiContextPath: "/bm"
      },
      "extraBabelPlugins": [
        "transform-runtime",
        ["import", { "libraryName": "antd", "style": true }]
      ]
    }
  }
};
