import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Table } from 'antd';
import Search from './search';

class TableEx extends Component {

  static initColumns(props) {
    return (props.columns || []).map((column, index) => {
      const filter = props.filters ? props.filters[index] : null;
      return {
        key: column.dataIndex,
        filtered: !!filter,
        filterDropdownVisible: false,
        filter,
      };
    });
  }
  constructor(props, context) {
    super(props, context);
    const columns = TableEx.initColumns(props);
    this.state = {
      columns,
    };
  }

  componentWillReceiveProps(nextProps) {
    if (nextProps.columns !== this.props.columns) {
      const columns = TableEx.initColumns(nextProps);
      this.setState({
        columns,
      });
    }
  }

  makeColumns() {
    if (!this.props.columns) {
      return [];
    }
    return this.props.columns.map((column, index) => {
      const ret = {
        ...column,
      };
      const state = this.state.columns[index];
      if (ret.filterType) {
        const onSearch = (filter) => {
          const newColumns = [...this.state.columns];
          newColumns[index].filter = filter;
          newColumns[index].filtered = !!filter;
          newColumns[index].filterDropdownVisible = false;
          this.setState({ columns: newColumns }, () => {
            this.props.onFilter(this.state.columns.map(c => ({
              key: c.key,
              filter: c.filter,
            })));
          });
        };
        ret.filterDropdown = (
          <Search type={ret.filterType} onSearchSubmit={onSearch} filterEnums={ret.filterEnums} />
        );
        ret.filterDropdownVisible = state.filterDropdownVisible;
        ret.onFilterDropdownVisibleChange = (visible) => {
          const newColumns = [...this.state.columns];
          newColumns[index].filterDropdownVisible = visible;
          this.setState({ columns: newColumns });
        };
        ret.filterIcon = Search.getIcon(ret.filterType, state.filtered);
      }
      return ret;
    }, this);
  }
  render() {
    return (
      <Table {...this.props} columns={this.makeColumns()} />
    );
  }
}

const funcVoid = () => {};

TableEx.propTypes = {
  onFilter: PropTypes.func,
};
TableEx.defaultProps = {
  onFilter: funcVoid,
};

export default TableEx;

