import { flatMap } from 'lodash';
import { fetchMenus, fetchModuleInfos, fetchModuleLayout } from '../services/modules';

const data = {
  flags: {
    menus: false,
    infos: false,
    layout: {},
  },
  menus: [],
  infos: [],
  layout: {},
};
export default data;

// export const setMenus = (menus) => {
//   data.init = true;
//   data.menus = menus;
// };

const combineMenu = (menu1, menu2) => {
  return {
    ...menu2,
    children: combineMenus(menu1.children, menu2.children),
  };
};

const combineMenus = (menus1, menus2) => {
  const menus = [...menus1];
  for (const menu of menus2) {
    let find = false;
    for (const i in menus) {
      if (menus[i].name === menu.name) {
        menus[i] = combineMenu(menus[i], menu);
        find = true;
        break;
      }
    }
    if (!find) {
      menus.push(menu);
    }
  }
  return menus;
};

export const getMenus = async () => {
  if (!data.flags.menus) {
    const context = require.context('../register/modules', true, /^.*\.(js|jsx|json)/);
    const staticMenus = flatMap(context.keys(), context);
    const dynamicMenus = await fetchMenus();
    data.menus = combineMenus(staticMenus, dynamicMenus);
    data.flags.menus = true;
  }
  return data.menus;
};

export const invalidateMenus = () => {
  data.flags.menus = false;
};

export const getModuleInfos = async () => {
  if (!data.flags.infos) {
    data.infos = await fetchModuleInfos();
    data.flags.infos = true;
  }
  return data.infos;
};

export const getModuleInfo = async (name) => {
  const infos = await getModuleInfos();
  return (infos || []).filter(info => info.name === name).pop();
};

export const invalidateInfos = () => {
  data.flags.infos = false;
};

export const getModuleLayout = async (name) => {
  if (!data.flags.layout[name]) {
    data.layout[name] = await fetchModuleLayout(name);
    data.flags.layout[name] = true;
  }
  return data.layout[name];
};

export const invalidateLayout = (name) => {
  delete data.flags.layout[name];
};

export const invalidateLayouts = () => {
  data.flags.layout = {};
};
