import { routerRedux } from 'dva/router';
import { login, userInfo } from '../services/login';
import { fullPath } from '../utils/helper';
import { setToken, setUser, setDomain, histories } from '../utils/auth';
import { switchDomain, currentDomain } from '../services/domain';
import { errors } from '../utils/error';
import config from '../utils/config';

export default {
  namespace: 'login',
  state: {},
  reducers: {},
  effects: {
    *login({ payload }, { call, put }) {
      const loginRequest = {
        type: 'userName',
        data: payload.userName,
        authRequest: {
          type: 'password',
          parameters: {
            cipher: payload.password,
          },
        },
      };
      const result = yield call(login, loginRequest);
      const { tokenId, authResponse, remainedAuthRequirements } = result;
      if (authResponse.status !== 'authed' && authResponse.status !== 'skipped') {
        throw errors.wrongPassword();
      }
      const { requirements } = remainedAuthRequirements;
      if (requirements.length > 0) {
        throw errors.unsupportedAuthType(requirements);
      }
      yield call(setToken, tokenId);
      const uInfo = yield call(userInfo);
      yield call(setUser, uInfo.id, uInfo.name);
      const path = yield call(histories.getLatest, 'domain');
      if (!path) {
        yield put(routerRedux.push(fullPath('/domain')));
      } else {
        yield call(switchDomain, path);
        const { name } = yield call(currentDomain);
        yield call(setDomain, name, path);
        if (config.fastNavigationPage) {
          yield put(routerRedux.push(fullPath('/fastNav')));
        } else {
          yield put(routerRedux.push(fullPath('/main')));
        }
      }
    },
  },
  subscriptions: {},
};
