/**
 * Created by yaohx_169 on 2017/6/5.
 */
import React from 'react';
import PropTypes from 'prop-types';
import { Form, Icon, Input, Checkbox, Button } from 'antd';
import { connect } from 'dva';
import config from '../../utils/config';
import styles from './index.less';

const FormItem = Form.Item;

class LoginForm extends React.Component {

  constructor(props, context) {
    super(props, context);
    this.handleSubmit = this::this.handleSubmit;
  }


  handleSubmit(e) {
    e.preventDefault();
    this.props.form.validateFields((err, values) => {
      if (!err) {
        this.props.dispatch({
          type: 'login/login',
          payload: {
            type: 'userName',
            authType: 'password',
            ...values,
          },
        });
      }
    });
  }

  render() {
    const { getFieldDecorator } = this.props.form;
    const loading = this.props.loading;
    return (
      <div className={styles.canvas}>
        <div className={styles.container}>
          <div className={styles.logo}>
            <img alt="logo" src={config.logo} />
            <span>{config.name}</span>
          </div>
          <Form onSubmit={this.handleSubmit}>
            <FormItem>
              {
                getFieldDecorator('userName', {
                  rules: [{
                    required: true,
                    message: '请输入用户名。',
                  }],
                })(
                  <Input prefix={<Icon type="user" />} placeholder="用户名" />,
                )
              }
            </FormItem>
            <FormItem>
              {
                getFieldDecorator('password', {
                  rules: [{
                    required: true,
                    message: '请输入密码。',
                  }],
                })(
                  <Input prefix={<Icon type="lock" />} type="password" placeholder="密码" />,
                )
              }
            </FormItem>
            <FormItem>
              {
                getFieldDecorator('remember', {
                  valuePropName: 'checked',
                  initialValue: true,
                })(
                  <Checkbox>记住我</Checkbox>,
                )
              }
              <a className={styles.forgot} href="">忘记密码</a>
              <Button type="primary" htmlType="submit" className={styles.submit} loading={loading}>
                登录
              </Button>
              或者<a>现在注册！</a>
            </FormItem>
          </Form>
        </div>
      </div>
    );
  }

}

LoginForm.propTypes = {
  form: PropTypes.object,
  loading: PropTypes.bool,
  dispatch: PropTypes.func,
};

const mapStateToProps = ({ login, loading }) => {
  return {
    login,
    loading: loading.effects['login/login'],
  };
};

export default connect(mapStateToProps)(Form.create()(LoginForm));
