/* eslint-disable no-param-reassign */
/** @module services/login */
import { getDeviceId } from '../utils/device';
import post from '../utils/post';
import request from '../utils/request';
import { encrypt } from '../utils/helper';
import { getToken } from '../utils/auth';
import config from '../utils/config';

/**
 * @typedef {Object} TokenInfo
 * @property {number} [life]
 * @property {boolean} [persist]
 * @property {!string} productId
 * @property {!string} deviceId
 */

/**
 * @typedef {Object} LoginRequest
 * @property {!string} type
 * @property {string} [data]
 * @property {TokenInfo} [tokenInfo]
 * @property {AuthRequest} [authRequest]
 */

/**
 * @typedef {Object} AuthRequest
 * @property {!string} type
 * @property {Object} [parameters]
 */

/**
 * @typedef {Object} LoginResponse
 * @property {!string} tokenId
 * @property {?AuthResponse} authResponse
 * @property {!AuthRequirements} remainedAuthRequirements
 */

/**
 * @typedef {Object} AuthResponse
 * @property {!string} type
 * @property {!string} status
 * @property {?Object} data
 */

/**
 * @typedef {Object} AuthRequirements
 * @property {Array.<AuthRequirement>} requirements
 */

/**
 * @typedef {Object} AuthRequirement
 * @property {Array.<string>} authTypes
 */

/**
 * 登录
 * @param {!LoginRequest} loginRequest 登录请求
 * @returns {Promise.<LoginResponse>}
 */
export async function login(loginRequest) {
  if (!loginRequest.tokenInfo) {
    loginRequest.tokenInfo = {
      productId: config.productId,
      deviceId: `${getDeviceId()}`,
    };
  }
  return post(`${config.apiContextPath}/api/auth/login`, loginRequest, {}, {}, false);
}

/**
 * 认证
 * @param {{tkId: ?string, request: AuthRequest}} authRequest 认证请求
 * @return {Promise.<AuthResponse>}
 */
export async function authorize(authRequest) {
  if (!authRequest.tkId) {
    authRequest.tkId = encrypt(await getToken());
  }
  return post(`${config.apiContextPath}/api/auth/authorize`, authRequest, {}, {}, false);
}

export async function userInfo() {
  return request(`${config.apiContextPath}/api/user/info`);
}
