import { partial } from 'lodash';
import request from '../utils/request';
import post from '../utils/post';
import config from '../utils/config';

export const userApi = (id) => {
  return {
    admin: {
      getConfigure: partial(getUserConfigure, id),
      setConfigure: partial(setUserConfigure, id),
      refresh: partial(refreshUser, id),
    },
  };
};

export const roleApi = (id) => {
  return {
    admin: {
      getConfigure: partial(getRoleConfigure, id),
      setConfigure: partial(setRoleConfigure, id),
      refresh: partial(refreshRole, id),
    },
  };
};

export async function getUserConfigure(id) {
  return request(`${config.apiContextPath}/api/user/admin/user/${id}/configure`);
}

export async function setUserConfigure(id, configure) {
  return post(`${config.apiContextPath}/api/user/admin/user/${id}/configure`, { configure });
}

export async function refreshUser(id) {
  return post(`${config.apiContextPath}/api/user/admin/user/${id}/refresh`);
}

export async function getRoleConfigure(id) {
  return request(`${config.apiContextPath}/api/user/admin/role/${id}/configure`);
}

export async function setRoleConfigure(id, configure) {
  return post(`${config.apiContextPath}/api/user/admin/role/${id}/configure`, { configure });
}

export async function refreshRole(id) {
  return post(`${config.apiContextPath}/api/user/admin/role/${id}/refresh`);
}

