/* eslint-disable no-undef */
/**
 * Created by yaohx_169 on 2017/6/6.
 */

export const cookie = {
  token: 'token',
  userId: 'userId',
  userName: 'userName',
  domainPath: 'domainPath',
  domainName: 'domainName',
};

export const errors = {
  exception: 0x00010000,
  no_such_user: 0x00010001,
  invalid_token: 0x00010003,
  // client error:
  token_missing: 0x00000001,
  wrong_password: 0x00000002,
  unsupported_auth_type: 0x00000003,
};

export const api = {
  userLogin: '/user/login',
  userLogout: '/user/logout',
  userInfo: '/userInfo',
  users: '/users',
  user: '/user/:id',
  dashboard: '/dashboard',
};

const defaultDateFormat = 'YYYY-MM-DD';
const defaultTimeFormat = 'HH:mm:ss';
const defaultDateTimeFormat = `${defaultDateFormat} ${defaultTimeFormat}`;

// eslint-disable-next-line no-underscore-dangle
const _apiContextPath = process.env.NODE_ENV === 'development' ? '' : apiContextPath;
// eslint-disable-next-line no-underscore-dangle
const _contextPath = process.env.NODE_ENV === 'development' ? '' : contextPath;

const config = {
  name: 'Jbpm Demo',
  footerText: '上海铂蓝信息科技有限公司',
  logo: `${_contextPath}/logo.png`,
  contextPath: _contextPath,
  apiContextPath: _apiContextPath,
  productId: 'big-machine-web-front',
  fastNavigationPage: '',
  defaultDateFormat,
  defaultTimeFormat,
  defaultDateTimeFormat,
  pubKey: '-----BEGIN PUBLIC KEY-----MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC+/Rs6dYmdtETjHCZq4LF3QjLM/DocRAXrqtMULZf+579dAn+CiM8noLplZT/DRwvfK822eq8sypH+a4NqP7942pPVjOudVvKfiJvmm2TOQHvQ7vi3iyZVdlsxX72JNFo1Ocqwj48aIC/OJ4bMf/VyCKrmKrU2iXND+I4BN8cfhwIDAQAB-----END PUBLIC KEY-----',
};

export default config;
