export const makeCancelable = (promise, silence = true) => {
  let hasCanceled = false;
  const canceledError = { isCanceled: true };
  const wrappedPromise = new Promise((resolve, reject) => {
    promise.then(
      val => (hasCanceled ? reject(canceledError) : resolve(val)),
      error => (hasCanceled ? reject(canceledError) : reject(error)),
    );
  });

  return {
    run: cb => cb(wrappedPromise).catch((err) => {
      if (silence && err !== canceledError) {
        throw err;
      }
    }),
    cancel() {
      hasCanceled = true;
    },
  };
};
