import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { filterValidParams } from '../../utils/helper';

class TwoBind extends Component {

  constructor(props, context) {
    super(props, context);
    this.state = {
      value: '',
    };
  }

  componentWillReceiveProps(nextProps) {
    this.setState({
      value: nextProps[nextProps.valueKey],
    });
  }

  render() {
    const { valueKey, cbKey, cbMap, wrapped, children, ...rest } = this.props.children.props;
    const Wrapped = wrapped;
    const callback = (cbValue) => {
      this.setState({
        value: cbMap(cbValue),
      });
    };
    const props = {
      [valueKey]: this.state.value,
      [cbKey]: callback,
    };
    return (
      <Wrapped {...rest} {...props}>
        { children }
      </Wrapped>
    );
  }
}

TwoBind.propTypes = {
  valueKey: PropTypes.string,
  cbKey: PropTypes.string,
  cbMap: PropTypes.func,
  wrapped: PropTypes.func.isRequired,
};
const fucIdentity = value => value;
TwoBind.defaultProps = {
  valueKey: 'value',
  cbKey: 'onChange',
  cbMap: fucIdentity,
};

const makeTwoBind = ({ valueKey, cbKey, cbMap } = {}) => (Comp) => {
  const params = filterValidParams({ valueKey, cbKey, cbMap });
  return <TwoBind {...params} wrapped={Comp} />;
};

export default makeTwoBind;
