import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Input, Spin } from 'antd';
import { getCert, init, sign } from '../../utils/uca';

class UCA extends Component {

  constructor(props, context) {
    super(props, context);
    this.state = {
      ready: false,
    };
  }

  componentDidMount() {
    this.task = setInterval(() => {
      const res = init();
      if (res === 0) {
        clearInterval(this.task);
        this.task = null;
        this.setState({
          ready: true,
        });
      }
    }, 300);
  }

  componentWillUnmount() {
    if (this.task) {
      clearInterval(this.task);
    }
  }

  onChange = (value) => {
    if (this.state.ready && this.props.onChange) {
      this.props.onChange(this.valueToObj(value));
    }
  };
  objToValue = (obj) => {
    return obj ? obj.input : '';
  };
  valueToObj = (value) => {
    if (!value) {
      return value;
    }
    if (this.props.data) {
      return sign(value, this.props.data);
    } else {
      return getCert(value);
    }
  };
  render() {
    const onChange = (e) => {
      return this.onChange(e.target.value);
    };
    const { loading, value, ...rest } = this.props;
    return (
      <Spin spinning={!this.state.ready || loading} size="small">
        <Input {...rest} disabled={!this.state.ready || loading} value={this.objToValue(value)} onChange={onChange} />
      </Spin>
    );
  }
}

UCA.propTypes = {
  loading: PropTypes.bool,
  data: PropTypes.string,
};

UCA.defaultProps = {
  loading: false,
};

export default UCA;
