import Mock from 'mockjs';
import moment from 'moment';
import _ from 'lodash';

const defaultDateFormat = 'YYYY-MM-DD';
const defaultTimeFormat = 'HH:mm:ss';
const defaultDateTimeFormat = `${defaultDateFormat} ${defaultTimeFormat}`;

const Random = Mock.Random;

export function getTasks() {
  const states = ['状态1', '状态2', '状态3', '状态4', '状态5', '状态5'];
  const start = Random.natural(0, 100);
  const end = Random.natural(start + 5, start + 20);
  const progresses = Random.range(start, end).map(idx => ({
    id: idx,
    name: `流程${idx}`,
  }));
  const tasks = _.flatMap(progresses, (progress) => {
    const s = Random.natural(0, 100);
    const e = Random.natural(start + 5, start + 20);
    return Random.range(s, e).map((idx) => {
      const dateOffset = {
        days: Random.natural(0, 60),
        hours: Random.natural(0, 23),
        minutes: Random.natural(0, 59),
        seconds: Random.natural(0, 59),
        milliseconds: Random.natural(0, 999),
      };
      const deadLineOffset = {
        days: Random.natural(0, 180),
        hours: Random.natural(0, 23),
        minutes: Random.natural(0, 59),
        seconds: Random.natural(0, 59),
        milliseconds: Random.natural(0, 999),
      };
      const date = moment().subtract(dateOffset);
      const deadline = date.add(deadLineOffset);
      return {
        pId: progress.id,
        pName: progress.name,
        nId: idx,
        nName: `任务${idx}`,
        state: Random.pick(states),
        date: date.format(defaultDateTimeFormat),
        deadline: deadline.format(defaultDateTimeFormat),
      };
    });
  });
  return Random.shuffle(tasks);
}
