/** @module utils/db */
import low from 'lowdb';
import LocalStorage from 'lowdb/adapters/LocalStorage';

const adapter = new LocalStorage('db');

/**
 * @typedef {Object} DB
 * @template {T}
 */

/**
 * @member {Function} DB~get
 * @param {Array.<string>|string} path
 * @param {*} [defaultValue]
 * @return {DB.<*>}
 */

/**
 * @member {Function} DB~set
 * @param {Array.<string>|string} path
 * @param value
 * @return {DB}
 */

/**
 * @member {Function} DB~find
 * @template {T}
 * @param {Function} [predicate=_.identity]
 * @param {number} [fromIndex=0]
 * @return {DB.<T>}
 */

/**
 * @member {Function} DB~unset
 * @param {Array.<string>|string} path
 * @return {DB.<boolean>}
 */

/**
 * @member {Function} DB~read
 * @return {Promise.<*>}
 */

/**
 * @member {Function} DB~write
 * @return {Promise.<*>}
 */

/**
 * @member {Function} DB~value
 * @template {T}
 * @return {Promise.<T>}
 */

/**
 * @type {DB.<*>}
 */
const db = low(adapter);

export default db;

