/* eslint-disable no-param-reassign,prefer-rest-params */
/**
 * Created by yaohx_169 on 2017/5/10.
 */

/*
 * 添加事件处理程序
 * @param object object 要添加事件处理程序的元素
 * @param string type 事件名称，如click
 * @param function handler 事件处理程序，可以直接以匿名函数的形式给定，或者给一个已经定义的函数名。匿名函数方式给定的事件处理程序在IE6 IE7 IE8中可以移除，在标准浏览器中无法移除。
 * @param boolean remove 是否是移除的事件，本参数是为简化下面的removeEvent函数而写的，对添加事件处理程序不起任何作用
 */
export function addEvent(object, type, handler, remove) {
  if (typeof object !== 'object' || typeof handler !== 'function') return;
  try {
    object[remove ? 'removeEventListener' : 'addEventListener'](type, handler, false);
  } catch (e) {
    const xc = `_${type}`;
    object[xc] = object[xc] || [];
    if (remove) {
      const l = object[xc].length;
      for (let i = 0; i < l; i++) {
        if (object[xc][i].toString() === handler.toString()) object[xc].splice(i, 1);
      }
    } else {
      const l = object[xc].length;
      let exists = false;
      for (let i = 0; i < l; i++) {
        if (object[xc][i].toString() === handler.toString()) exists = true;
      }
      if (!exists) object[xc].push(handler);
    }
    object[`on${type}`] = function cb() {
      const l = object[xc].length;
      for (let i = 0; i < l; i++) {
        object[xc][i].apply(object, arguments);
      }
    };
  }
}
/*
 * 移除事件处理程序
 */
export function removeEvent(object, type, handler) {
  addEvent(object, type, handler, true);
}
