/* eslint-disable no-unused-vars */
import { getToken } from './auth';
import { encrypt } from './helper';
import { errors } from './error';

const putTokenOnUrl = async (url, params, options) => {
  let token = await getToken();
  if (!token) {
    throw errors.tokenMissing();
  }
  token = encrypt(token);
  return {
    url,
    options,
    params: [...params, ['token', token]],
  };
};

const putTokenToBody = async (url, data, params, options) => {
  let token = await getToken();
  if (!token) {
    throw errors.tokenMissing();
  }
  token = encrypt(token);
  return {
    url,
    params,
    options,
    data: {
      ...data,
      token,
    },
  };
};

const parseResponse = (response) => {
  const { errorCode, data, message } = response;
  if (errorCode === 0) {
    return data;
  } else {
    throw new Error(message || data);
  }
};

export default {
  get: {
    onRequest: async (url, params, options, auth) => {
      if (auth) {
        return putTokenOnUrl(url, params, options);
      }
    },
    onResponse: parseResponse,
  },
  post: {
    onRequest: async (url, data, params, options, auth) => {
      if (auth) {
        return putTokenToBody(url, data, params, options);
      }
    },
    onResponse: parseResponse,
  },
  delete: {
    onRequest: async (url, params, options, auth) => {
      if (auth) {
        return putTokenOnUrl(url, params, options);
      }
    },
    onResponse: parseResponse,
  },
};

