import React from 'react';
import sm from 'react-sizeme';
import hoistStatics from 'hoist-non-react-statics';
import { shallowEqual } from '../../utils/helper';

const SizeMeContext = React.createContext('sizeMe');
export const { Provider, Consumer } = SizeMeContext;

export const provideSize = options => (Component) => {
  const WC = class WrappedComponent extends React.Component {
    render() {
      const { size, forwardedRef, children, ...rest } = this.props;
      if (!shallowEqual(this.size, size)) {
        this.size = size;
      }
      return (
        <Provider value={this.size}>
          <Component ref={forwardedRef} {...rest}>
            {children || null}
          </Component>
        </Provider>
      );
    }
  };
  const SizeMeComponent = sm(options)(WC);
  const C = React.forwardRef((props, ref) => (
    <SizeMeComponent forwardedRef={ref} {...props} />
  ));
  C.displayName = `provideSize(${Component.displayName || Component.name}}`;
  return hoistStatics(C, Component);
};

export const provideWidth = provideSize({});
export const provideHeight = provideSize({ monitorHeight: true });

export const withSize = (Component) => {
  const C = React.forwardRef((props, ref) => (
    <Consumer>
      { size => (
        <Component {...props} size={size} ref={ref} />
      )}
    </Consumer>
  ));
  C.displayName = `withSize(${Component.displayName || Component.name})`;
  return hoistStatics(C, Component);
};
