import React from 'react';
import { addEvent, removeEvent } from '../../utils/dom';

class RootPanel extends React.Component {

  constructor(props, context) {
    super(props, context);
    this.attachNode = this::this.attachNode;
    this.updateHeight = this::this.updateHeight;
    this.state = {
      height: 0,
    };
  }

  componentDidMount() {
    addEvent(window, 'resize', this.updateHeight); // eslint-disable-line no-undef
    this.updateHeight();
  }

  componentWillUnmount() {
    removeEvent(window, 'resize', this.updateHeight); // eslint-disable-line no-undef
  }


  updateHeight() {
    const parentNode = this.node.parentNode;
    this.setState({
      height: parentNode.offsetHeight,
    });
  }

  attachNode(node) {
    this.node = node;
  }

  render() {
    const { children, style, ...rest } = this.props;
    return (
      <div style={{ ...style, height: this.state.height }} {...rest} ref={this.attachNode}>{ children }</div>
    );
  }
}

export default RootPanel;
