import React from 'react';
import PropTypes from 'prop-types';
import modelCreator from './model';
import connect from '../../hoc/stateful';
import TableEx from '../../../components/table/index';
import { shallowEqual } from '../../../utils/helper';
import styles from './index.less';

class DsTable extends React.Component {
  componentDidMount() {
    const { coordinate, params, dispatchLocal } = this.props;
    dispatchLocal({ type: 'doInit', payload: { coordinate, params } });
  }

  componentWillReceiveProps(nextProps) {
    const { coordinate, params } = nextProps;
    const { dispatchLocal } = this.props;
    if (!shallowEqual(coordinate, this.props.coordinate) || !shallowEqual(params, this.props.params)) {
      dispatchLocal({ type: 'doInit', payload: { coordinate, params } });
    }
  }

  render() {
    const { dispatchLocal } = this.props;
    const { props, columns, current, pageSize, filters, list, num } = this.props.model;
    const tableProps = {
      dataSource: list,
      ...props,
      columns,
      filters: filters.map(filter => filter.filter),
      loading: this.props.loading.model,
      pagination: {
        current,
        total: num,
        pageSize,
      },
      onChange: (pagination, theFilters, sorter) => {
        if (current !== pagination.current) {
          dispatchLocal({ type: 'changeCurrentPage', payload: pagination.current });
        }
        if (pageSize !== pagination.pageSize) {
          dispatchLocal({ type: 'changePageSize', payload: pagination.pageSize });
        }
        const { field, order } = sorter;
        if (field) {
          dispatchLocal({ type: 'doSort', payload: { field, order } });
        }
      },
      onFilter: (theFilters) => {
        dispatchLocal({ type: 'doFilter', payload: theFilters });
      },
    };
    return (
      <div className={styles.wrapper}>
        <div className={styles.container}>
          <TableEx {...tableProps} />
        </div>
      </div>
    );
  }
}

DsTable.propTypes = {
  coordinate: PropTypes.oneOfType(
    [
      PropTypes.string,
      PropTypes.shape({
        containerType: PropTypes.string,
        containerName: PropTypes.string,
        datasourceName: PropTypes.string,
      }),
    ],
  ).isRequired,
};

export default connect(modelCreator, {
  mapStateToProps: ({ loading }) => ({ loading }),
})(DsTable);
