import React, { Component } from 'react';
import castArray from 'lodash/castArray';
import noop from 'lodash/noop';
import { Table, Button, Form } from 'antd';

class TableInput extends Component {

  constructor(props, context) {
    super(props, context);
    this.onAdd = this::this.onAdd;
    this.onOk = this::this.onOk;
    this.state = {
      editing: false,
      operation: 'none',
    };
  }

  onAdd() {
    this.setState({
      editing: true,
      operation: 'add',
    });
  }
  onOk() {
    const { value, items, form, onChange } = this.props;
    const row = {};
    castArray(items).forEach((item) => {
      row[item.name] = form.getFieldValue(item.name);
    });
    if (this.state.operation === 'add') {
      (onChange || noop)([...(value || []), row]);
    }
    this.setState({
      editing: false,
      operation: 'none',
    });
  }
  makeColumns() {
    const { items } = this.props;
    return castArray(items)
      .map((item) => {
        return {
          ...item,
          title: item.label,
          key: item.name,
          dataIndex: item.name,
        };
      });
  }
  makeDataSource() {
    const { value } = this.props;
    return castArray(value || [])
      .map((row, idx) => ({
        ...row,
        __key__: idx,
      }));
  }

  render() {
    const { items, form, children } = this.props;
    if (this.state.editing) {
      const fields = castArray(children)
        .map(
          (child, i) => {
            const item = items[i];
            return (
              <Form.Item {...item}>
                {
                  form.getFieldDecorator(item.name, item)(
                    child,
                  )
                }
              </Form.Item>
            );
          },
          this,
        );
      return (
        <div>
          {[
            ...fields,
            <Button onClick={this.onOk}>确定</Button>,
          ]}
        </div>
      );
    } else {
      return (
        <div>
          <Button onClick={this.onAdd}>新增</Button>
          <Table rowKey="__key__" dataSource={this.makeDataSource()} columns={this.makeColumns()} />
        </div>
      );
    }
  }
}

export default Form.create()(TableInput);
