import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Input, Icon, Button } from 'antd';
import styles from './text.less';

class TextSearch extends Component {

  constructor(props, context) {
    super(props, context);
    this.onChange = this::this.onChange;
    this.bindRef = this::this.bindRef;
    this.submit = this::this.submit;
    this.emitEmpty = this::this.emitEmpty;
    this.state = {
      value: '',
    };
  }
  onChange(e) {
    const { onSearchPreChange, onSearchChanged } = this.props;
    const value = onSearchPreChange(e.target.value);
    this.setState({ value }, () => onSearchChanged(value));
  }

  bindRef(node) {
    this.input = node;
  }

  submit() {
    const { onSearchSubmit } = this.props;
    const value = this.state.value;
    const filter = value ? `@%${value}%` : null;
    onSearchSubmit(filter);
  }

  emitEmpty() {
    this.input.focus();
    this.setState({
      value: '',
    });
  }

  render() {
    const { onSearchPreChange, onSearchChanged, onSearchSubmit, ...rest } = this.props; // eslint-disable-line no-unused-vars
    const props = {
      suffix: this.state.value ? <Icon type="close" style={{ marginRight: '4px' }} onClick={this.emitEmpty} /> : null,
      value: this.state.value,
      onChange: this.onChange,
      onPressEnter: this.submit,
      ref: this.bindRef,
    };
    return (
      <div className={styles.container}>
        <div className={styles.inputWrapper}>
          <Input {...rest} {...props} />
        </div>
        <Button className={styles.popupOk} onClick={this.submit}>ok</Button>
      </div>
    );
  }
}

TextSearch.propTypes = {
  onSearchPreChange: PropTypes.func,
  onSearchChanged: PropTypes.func,
  onSearchSubmit: PropTypes.func,
};

const funcIdentity = value => value;
const funcVoid = () => {};

TextSearch.defaultProps = {
  onSearchPreChange: funcIdentity,
  onSearchChanged: funcVoid,
  onSearchSubmit: funcVoid,
};

export default TextSearch;
