import { routerRedux } from 'dva/router';
import { fetchDomains, switchDomain, getInfo, currentDomain } from '../services/domain';
import { getDomain, getUser, histories, setDomain } from '../utils/auth';
import config from '../utils/config';

export default {

  namespace: 'domain',

  state: {
    init: undefined,
    list: [],
  },

  subscriptions: {
    setup({ dispatch }) {  // eslint-disable-line
    },
  },

  effects: {
    *fetch(ignored, { put, call }) {
      const domain = yield call(getDomain);
      let init;
      if (domain && domain.path) {
        init = yield call(getInfo, domain.path);
      }
      if (!init) {
        init = yield call(currentDomain);
      }
      const list = yield call(fetchDomains, '/', true);
      yield put({ type: 'queryInit', payload: init });
      yield put({ type: 'queryList', payload: list });
    },
    *switch({ payload: domainPath }, { put, call }) {
      yield call(switchDomain, domainPath);
      const { path, name } = yield call(currentDomain);
      yield call(setDomain, name, path);
      yield put({ type: 'queryInit', payload: path });
      const user = yield call(getUser);
      const latest = yield call(histories.getLatest, 'module', user && user.id);
      if (latest && config.fastNavigationPage) {
        yield put(routerRedux.push('/fastNav'));
      } else {
        yield put(routerRedux.push('/main'));
      }
    },
  },

  reducers: {
    queryInit(state, { payload: init }) {
      return {
        ...state,
        init,
      };
    },
    queryList(state, { payload: list }) {
      return {
        ...state,
        list,
      };
    },
  },

};
